/*
 * Copyright (c) 2024, Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * 'Software'), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

////////////////////////////////////////////////////////////////////////////////
// !!! WARNING - AUTO GENERATED FILE. DO NOT EDIT DIRECTLY. !!!
// Generated by KernelBinToSource.exe tool
////////////////////////////////////////////////////////////////////////////////

#if !defined(MEDIA_BIN_DLL)
#include "vp_platform_interface.h"
#include "vp_render_common.h"
#endif
#include "igvp3dlut_xe2.h"

#if defined(MEDIA_BIN_SUPPORT) && !defined(MEDIA_BIN_DLL)

unsigned int IGVP3DLUT_GENERATION_XE2_SIZE = 0;
unsigned int *IGVP3DLUT_GENERATION_XE2 = nullptr;
static bool getIGVP3DLUT_XE2 = LoadMediaBin(IGVP3DLUT_GENERATION_XE2_NAME, &IGVP3DLUT_GENERATION_XE2_SIZE, &IGVP3DLUT_GENERATION_XE2);

#endif  // defined(MEDIA_BIN_SUPPORT) && !defined(MEDIA_BIN_DLL)

#if !defined(MEDIA_BIN_DLL)
void AddVpNativeKernelEntryToList3dlutXe2(vp::VpPlatformInterface &vpPlatformInterface)
{
    vp::KRN_ARG FILLLUTTABLE_CURBE[] =
    {
        {LUT_FILLLUTTABLE_IOLUTINDEX, 0, 0, 8, vp::ARG_KIND_SURFACE, false, vp::AddressingModeStateless},
        {LUT_FILLLUTTABLE_ICOEFINDEX, 8, 0, 8, vp::ARG_KIND_SURFACE, false, vp::AddressingModeStateless},
        {LUT_FILLLUTTABLE_LUTSIZE, 16, 0, 4, vp::ARG_KIND_GENERAL, false, vp::AddressingModeStateful},
        {LUT_FILLLUTTABLE_MULSIZE, 20, 0, 4, vp::ARG_KIND_GENERAL, false, vp::AddressingModeStateful},
        {LUT_FILLLUTTABLE_PRIVATE_BASE_STATELESS, 24, 0, 8, vp::ARG_KIND_GENERAL, false, vp::AddressingModeStateful},
        {LUT_FILLLUTTABLE_GLOBAL_ID_OFFSET, 0, 0, 12, vp::ARG_KIND_INLINE},
        {LUT_FILLLUTTABLE_LOCAL_SIZE, 12, 0, 12, vp::ARG_KIND_INLINE},
    };

    vp::KRN_EXECUTE_ENV FILLLUTTABLE_PARAM =
    {
        0,         //barrier_count
        true,      //disable_mid_thread_preemption
        128,       //grf_count
        false,     //has_global_atomics
        true,      //has_no_stateless_write
        32,        //inline_data_payload_size
        192,       //offset_to_skip_per_thread_data_load
        32,        //simd_size
        true,      //subgroup_independent_forward_progress
        8,         //eu_thread_count
        false,     //has_fence_for_image_access
        false,     //has_sample
        true,      //has_4gb_buffers
        { 0, 0, 0 },         //work_group_walk_order_dimensions
        0,         //private_size
        0         //slm_size
    };

    vp::KRN_BTI* FILLLUTTABLE_BTI = nullptr;

    vpPlatformInterface.InitVpDelayedNativeAdvKernel((uint32_t *)((uint8_t *)IGVP3DLUT_GENERATION_XE2 + 0), 8192, FILLLUTTABLE_CURBE, 7, 32, FILLLUTTABLE_PARAM, FILLLUTTABLE_BTI, 0, "fillLutTable_3dlut");

}
#endif

#if !defined(MEDIA_BIN_SUPPORT) || defined(MEDIA_BIN_DLL)
DEFINE_SHARED_ARRAY_SIZE_UINT32(IGVP3DLUT_GENERATION_XE2_SIZE, 8192);
extern const unsigned int IGVP3DLUT_GENERATION_XE2[] =
{
    0x80100061, 0x7f054220, 0x00000000, 0x00000000, 0x80000065, 0x7f258220, 0x02000004, 0xffffffc0, 
    0x80000065, 0x7f058110, 0x01000024, 0x00ff00ff, 0x80001a40, 0x7f258220, 0x02007f24, 0x00000020, 
    0x80001940, 0x7f258220, 0x02007f24, 0x00000000, 0x8000195b, 0x7f048220, 0x01017f24, 0x00c07f04, 
    0x800c0061, 0x04050220, 0x00100104, 0x00000000, 0x80012031, 0x01140000, 0xfa007f8f, 0xf6780003, 
    0x8000c131, 0x030c0800, 0xfa007f8f, 0xf6740003, 0x00000060, 0x00000000, 0x00000000, 0x00000000, 
    0x00000060, 0x00000000, 0x00000000, 0x00000000, 0x00000060, 0x00000000, 0x00000000, 0x00000000, 
    0x3c8ca101, 0x00100000, 0x8000a065, 0x7f058220, 0x02000004, 0xffffffc0, 0x80001940, 0x7f058220, 
    0x02007f04, 0x00000000, 0x80032231, 0x050c0000, 0xfa007f8f, 0xf6700003, 0x2c240061, 0x0010004c, 
    0x80000966, 0x80018220, 0x02008000, 0x400004c0, 0x00172061, 0x4d050160, 0x00100104, 0x00000000, 
    0x00152270, 0x00010660, 0x56104d04, 0x00000544, 0x1414002e, 0x0000c000, 0x00001e08, 0x00001e08, 
    0x80000041, 0x20010660, 0x01004c14, 0x00000544, 0xac840053, 0x05814c01, 0x68840040, 0xfff40551, 
    0xac841a40, 0x4cf00102, 0x80141a70, 0x00010660, 0x16004c14, 0x00005104, 0x80001a41, 0x20010660, 
    0x01000204, 0x00000554, 0xac848153, 0x05b00203, 0xaca01940, 0x4d00034f, 0x84000020, 0x00004000, 
    0x00000000, 0x00000218, 0x80140070, 0x00018660, 0x15005104, 0x00000000, 0x84000020, 0x00004000, 
    0x00000000, 0x000001b8, 0x6884006c, 0x01f05101, 0x80001952, 0x02048660, 0x06050104, 0xffff0544, 
    0xac841967, 0x01100203, 0x80000967, 0x80018220, 0x01008000, 0x00300030, 0x80000961, 0x040502a0, 
    0x00000304, 0x00000000, 0x78840061, 0xb4c00009, 0x80001238, 0x08050aa0, 0x10000404, 0x00000000, 
    0x80000061, 0x070542a0, 0x00000000, 0x00010000, 0x22f0095b, 0x0908080a, 0x80000061, 0x05550a20, 
    0x00000404, 0x00000000, 0x80001261, 0x0c050a20, 0x00000704, 0x00000000, 0x20841141, 0x0a10070b, 
    0x80001a40, 0x06050660, 0x06000304, 0x02000554, 0x80001a40, 0x0615a660, 0x06000c04, 0x00010000, 
    0x80001161, 0x0d050a20, 0x00000b04, 0x00000000, 0x80001b61, 0x0e0502a0, 0x00000604, 0x00000000, 
    0x80001a61, 0x0e1502a0, 0x00000614, 0x00000000, 0x80001961, 0x0f0502a0, 0x00000d04, 0x00000000, 
    0x8000115b, 0x100402a0, 0x02220704, 0x04040f04, 0x8000005b, 0x110402a0, 0x02220e14, 0x0e040f04, 
    0x20841140, 0x11101012, 0x20841141, 0x12100a13, 0x80000967, 0x80018220, 0x01008000, 0x00300030, 
    0x80000961, 0x14050a20, 0x00001304, 0x00000000, 0xac841940, 0x0d101415, 0x80001941, 0x20010660, 
    0x01001504, 0x00000304, 0xac840053, 0x03101516, 0x80001940, 0x1705a660, 0x06001604, 0x00010000, 
    0xe8c41970, 0x03101718, 0x80001952, 0x19040660, 0x06261504, 0x18040104, 0xac841967, 0x01121951, 
    0x80000020, 0x00004000, 0x00000000, 0x00000018, 0xf4840061, 0xfff20051, 0x80001941, 0x20010660, 
    0x01004c14, 0x00005114, 0xac840053, 0x51414c01, 0x80001961, 0x512506a0, 0x00000104, 0x00000000, 
    0x80000020, 0x00004000, 0x00000000, 0x00000020, 0x80000061, 0x51254aa0, 0x00000000, 0x477fff00, 
    0x80140070, 0x00010660, 0x16004c64, 0x00005104, 0x80001141, 0x51358aa0, 0x0a005124, 0x37800080, 
    0x84000020, 0x00004000, 0x00000000, 0x00000228, 0x80140070, 0x00018660, 0x15005104, 0x00000000, 
    0x84000020, 0x00004000, 0x00000000, 0x000001b8, 0x6884006c, 0x01f05101, 0x80001952, 0x02048660, 
    0x06050104, 0xffff0544, 0xac841967, 0x01100203, 0x80000967, 0x80018220, 0x01008000, 0x00300030, 
    0x80000961, 0x040502a0, 0x00000304, 0x00000000, 0x78840061, 0xb4c00009, 0x80001238, 0x08050aa0, 
    0x10000404, 0x00000000, 0x80000061, 0x070542a0, 0x00000000, 0x00010000, 0x22f0095b, 0x0908080a, 
    0x80000061, 0x05550a20, 0x00000404, 0x00000000, 0x80001261, 0x0c050a20, 0x00000704, 0x00000000, 
    0x20841141, 0x0a10070b, 0x80001a40, 0x06050660, 0x06000304, 0x02000554, 0x80001a40, 0x0615a660, 
    0x06000c04, 0x00010000, 0x80001161, 0x0d050a20, 0x00000b04, 0x00000000, 0x80001b61, 0x0e0502a0, 
    0x00000604, 0x00000000, 0x80001a61, 0x0e1502a0, 0x00000614, 0x00000000, 0x80001961, 0x0f0502a0, 
    0x00000d04, 0x00000000, 0x8000115b, 0x100402a0, 0x02220704, 0x04040f04, 0x8000005b, 0x110402a0, 
    0x02220e14, 0x0e040f04, 0x20841140, 0x11101012, 0x20841141, 0x12100a13, 0x80000967, 0x80018220, 
    0x01008000, 0x00300030, 0x80000961, 0x14050a20, 0x00001304, 0x00000000, 0xac841940, 0x0d101415, 
    0x80001941, 0x20010660, 0x01001504, 0x00000304, 0xac840053, 0x03101516, 0x80001940, 0x1705a660, 
    0x06001604, 0x00010000, 0xe8c41970, 0x03101718, 0x80001952, 0x19040660, 0x06261504, 0x18040104, 
    0xac841967, 0x011a1951, 0x80000020, 0x00004000, 0x00000000, 0x00000018, 0xf4840061, 0xfffa0051, 
    0x80001941, 0x20010660, 0x01004c64, 0x00005144, 0xac840053, 0x518c4c01, 0x80000061, 0x51650660, 
    0x00005144, 0x00000000, 0x80001a61, 0x515506a0, 0x00000104, 0x00000000, 0x80000020, 0x00004000, 
    0x00000000, 0x00000210, 0x80140070, 0x00018660, 0x15005104, 0x00000000, 0x84000020, 0x00004000, 
    0x00000000, 0x000001c0, 0x6884116c, 0x01f05101, 0x80001952, 0x02048660, 0x06050104, 0xffff0544, 
    0xac841967, 0x01100203, 0x80000967, 0x80018220, 0x01008000, 0x00300030, 0x80000961, 0x040502a0, 
    0x00000304, 0x00000000, 0x78840061, 0xb4c00009, 0x80001238, 0x08050aa0, 0x10000404, 0x00000000, 
    0x80000061, 0x070542a0, 0x00000000, 0x00010000, 0x22f0095b, 0x0908080a, 0x80000061, 0x05450a20, 
    0x00000404, 0x00000000, 0x80001261, 0x0c050a20, 0x00000704, 0x00000000, 0x20841141, 0x0a10070b, 
    0x80001a40, 0x06050660, 0x06000304, 0x02000544, 0x80001a40, 0x0615a660, 0x06000c04, 0x00010000, 
    0x80001161, 0x0d050a20, 0x00000b04, 0x00000000, 0x80001b61, 0x0e0502a0, 0x00000604, 0x00000000, 
    0x80001a61, 0x0e1502a0, 0x00000614, 0x00000000, 0x80001961, 0x0f0502a0, 0x00000d04, 0x00000000, 
    0x8000115b, 0x100402a0, 0x02220704, 0x04040f04, 0x8000005b, 0x110402a0, 0x02220e14, 0x0e040f04, 
    0x20841140, 0x11101012, 0x20841141, 0x12100a13, 0x80000967, 0x80018220, 0x01008000, 0x00300030, 
    0x80000961, 0x14050a20, 0x00001304, 0x00000000, 0xac841940, 0x0d101415, 0x80001941, 0x20010660, 
    0x01001504, 0x00000304, 0xac840053, 0x03101516, 0x80001940, 0x1705a660, 0x06001604, 0x00010000, 
    0xe8c41970, 0x03101718, 0x80001952, 0x19040660, 0x06261504, 0x18040104, 0x80001967, 0x51750660, 
    0x06001904, 0x00000104, 0x80000020, 0x00004000, 0x00000000, 0x00000020, 0x80000061, 0x51754560, 
    0x00000000, 0xffffffff, 0x80001961, 0x51650660, 0x00005174, 0x00000000, 0x80000061, 0x51554aa0, 
    0x00000000, 0x477fff00, 0x80001141, 0x01058aa0, 0x0a005154, 0x37800080, 0x80101941, 0x20010660, 
    0x01005164, 0x00204d04, 0x80000038, 0x03051aa0, 0x20005134, 0x00000000, 0xac800053, 0x4d0c5106, 
    0x80001138, 0x08051aa0, 0x20000104, 0x00000000, 0x82100041, 0x20010660, 0x01005164, 0x00204e04, 
    0xac880053, 0x4e0c5107, 0x80002a41, 0x03058aa0, 0x0a000304, 0x3c4fcdac, 0x80002941, 0x08058aa0, 
    0x0a000804, 0x3c4fcdac, 0x00141961, 0x110506a0, 0x00100604, 0x00000000, 0x80001338, 0x13050aa0, 
    0x30000304, 0x00000000, 0x00141141, 0x14058aa0, 0x0a101104, 0x37800080, 0x80000038, 0x13150aa0, 
    0x30000804, 0x00000000, 0x80000061, 0x0a054aa0, 0x00000000, 0xc1958000, 0x80000061, 0x51854aa0, 
    0x00000000, 0x4196d000, 0x00141338, 0x17051aa0, 0x20101404, 0x00000000, 0x8004095b, 0x190402a0, 
    0x020a5184, 0x0a041304, 0x00142941, 0x17058aa0, 0x0a101704, 0x3c4fcdac, 0x80c01265, 0x1b058660, 
    0x16001914, 0x7f800000, 0x80000065, 0x1c058660, 0x16001904, 0x7f800000, 0x00141138, 0x1f050aa0, 
    0x30101704, 0x00000000, 0x80401a70, 0x00018220, 0x42001b04, 0x64000000, 0x80000061, 0x1d050110, 
    0x00003000, 0x00000000, 0x78840061, 0x4f80000b, 0xf89c295b, 0x1f0a5124, 0x80000061, 0x21050110, 
    0x00003100, 0x00000000, 0x80001a61, 0x31010110, 0x00001d04, 0x00000000, 0x84c01262, 0x22058aa0, 
    0x0a000b04, 0x3f800000, 0x80001165, 0x00018660, 0x16001904, 0x007fffff, 0x80800065, 0x00018660, 
    0x16001914, 0x007fffff, 0x84400062, 0x23058aa0, 0x0a000b04, 0x3f800000, 0x80000961, 0x31010110, 
    0x00002104, 0x00000000, 0x94000070, 0x00018660, 0x15001c04, 0x00000000, 0x80c00070, 0x00018220, 
    0x42001c04, 0x64000000, 0x94800070, 0x00018660, 0x15001b04, 0x00000000, 0x94400062, 0x26058aa0, 
    0x0a002204, 0x2f800000, 0x00541165, 0x28058660, 0x16102404, 0x7f800000, 0xec840061, 0x0010312a, 
    0x00540065, 0x00018660, 0x16102404, 0x007fffff, 0x80000061, 0x02050770, 0x00000524, 0x00000000, 
    0xec840061, 0x0010312b, 0x80034331, 0x090c0dc0, 0xfb00020c, 0x00200000, 0x80000064, 0x31010110, 
    0x00003000, 0x00000000, 0x00140070, 0x00018220, 0x42102804, 0x64000000, 0x94c00062, 0x27058aa0, 
    0x0a002304, 0x2f800000, 0x80001164, 0x33010110, 0x00003200, 0x00000000, 0xfc841c61, 0x00102b32, 
    0x80000061, 0x0c054990, 0x00000000, 0x00010001, 0x8000c431, 0x540c01c0, 0xfb00020c, 0x00200000, 
    0xec840061, 0x0010302e, 0xfc840061, 0x00102a30, 0x00140040, 0x20018aa0, 0x0a101f04, 0xbf560000, 
    0x04941262, 0x2f058110, 0x01000c04, 0x00000000, 0xfc841b61, 0x00102e32, 0x00140062, 0x20018aa0, 
    0x4a102000, 0x00000000, 0x04140062, 0x22018aa0, 0x0a000b04, 0x3f800000, 0x00141170, 0x00018660, 
    0x15102804, 0x00000000, 0x14940062, 0x22018aa0, 0x0a102200, 0x2f800000, 0x60200041, 0x22002432, 
    0x04140062, 0x31058110, 0x01000c04, 0x00000000, 0x00141138, 0x36050aa0, 0x10103204, 0x00000000, 
    0x00141966, 0x00020110, 0x21103104, 0x00102f04, 0x80000064, 0x32010220, 0x00003000, 0x00000000, 
    0x60202941, 0x2000363a, 0x04941970, 0x00010aa0, 0x1a102000, 0x00102404, 0x20840041, 0x2611192c, 
    0x70201341, 0x22003a20, 0x80000040, 0x16158aa0, 0x0a001314, 0xbf560000, 0x20840041, 0x2710192d, 
    0x80001438, 0x30050aa0, 0x10002c04, 0x00000000, 0x14940062, 0x40058aa0, 0x0a102000, 0x3f800000, 
    0x80000040, 0x16058aa0, 0x0a001304, 0xbf560000, 0x30c41462, 0x0001161e, 0x80001438, 0x34050aa0, 
    0x10002d04, 0x00000000, 0x30c41262, 0x0000161a, 0x00140038, 0x43051aa0, 0x20104004, 0x00000000, 
    0x20840a41, 0x1e103035, 0x84c00070, 0x00010aa0, 0x1a001e04, 0x00001914, 0x20840a41, 0x1a103438, 
    0x84400070, 0x00010aa0, 0x1a001a04, 0x00001904, 0x20841441, 0x26103539, 0x20841341, 0x2710383c, 
    0x94c01262, 0x3d058aa0, 0x0a003904, 0x3f800000, 0x00142941, 0x43058aa0, 0x0a104304, 0x40c8e06b, 
    0x94401362, 0x3e058aa0, 0x0a003c04, 0x3f800000, 0x80001338, 0x3f051aa0, 0x20003d04, 0x00000000, 
    0x00141238, 0x52050aa0, 0x30104304, 0x00000000, 0x80002a41, 0x3f058aa0, 0x0a003f04, 0x40c8e06b, 
    0x80001238, 0x42051aa0, 0x20003e04, 0x00000000, 0x78840061, 0x3e80000e, 0x80001238, 0x51a50aa0, 
    0x30003f04, 0x00000000, 0x80002a41, 0x42058aa0, 0x0a004204, 0x40c8e06b, 0x30842941, 0x3f275145, 
    0x80001238, 0x51950aa0, 0x30004204, 0x00000000, 0x78840061, 0x3e000010, 0xa6f0095b, 0x0e514547, 
    0x80148370, 0x00018660, 0x15000904, 0x00000000, 0x209c115b, 0x52104755, 0x94000020, 0x00004000, 
    0x00000000, 0x00000270, 0x80000061, 0x01050770, 0x00000524, 0x00000000, 0x80000061, 0x04054bb0, 
    0x3f1a36e2, 0xeb1c432d, 0x3c8ca401, 0x00100000, 0x80032531, 0x020c0f80, 0xfb00010c, 0x00240000, 
    0x80000061, 0x14054220, 0x00000000, 0x3d00346e, 0x80000061, 0x19054220, 0x00000000, 0x40400000, 
    0x80000061, 0x13054220, 0x00000000, 0x40000000, 0x80000061, 0x21054220, 0x00000000, 0x3f333333, 
    0x80000061, 0x51b54220, 0x00000000, 0x3d00346e, 0x80008561, 0x06050ab0, 0x00000204, 0x00000000, 
    0x80000061, 0x03050ab0, 0x00000214, 0x00000000, 0xe0842241, 0x04100607, 0xe0842241, 0x041a0305, 
    0x80002261, 0x08060ba0, 0x00000704, 0x00000000, 0x80002161, 0x51c60ba0, 0x00000544, 0x00000000, 
    0x30841241, 0x42000809, 0x80141270, 0x00010aa0, 0x6a000804, 0x000051c4, 0x28841244, 0x0010090a, 
    0x80000041, 0x1e058aa0, 0x0a0051c4, 0x3f733333, 0x30841241, 0x3d000a0b, 0x84001162, 0x51d50aa0, 
    0x0a0051c4, 0x00000b04, 0x80001140, 0x0c058aa0, 0x0a0051d4, 0xbd00346e, 0x80001141, 0x0e058aa0, 
    0x0a000c04, 0x3e4ccccd, 0x22f0095b, 0x190e141a, 0x80000040, 0x0f058aa0, 0x0a000e04, 0x3d00346e, 
    0x30841241, 0x42001a1b, 0x30841241, 0x42000f10, 0x28841245, 0x00101b1c, 0x28841245, 0x00101011, 
    0x30841241, 0x3d001c1d, 0x30841241, 0x3d001112, 0x84001262, 0x61150aa0, 0x0a0051c4, 0x00001d04, 
    0x22f01b5b, 0x130e1415, 0x20cc1262, 0x61401e1f, 0x84000062, 0x61950aa0, 0x0a0051c4, 0x00001204, 
    0x84001262, 0x61050aa0, 0x0a0051c4, 0x00001f04, 0x30840041, 0x42001516, 0x80001240, 0x20058aa0, 
    0x0a006104, 0xbd00346e, 0x28841245, 0x00101617, 0x22f00a5b, 0x21201422, 0x30841241, 0x3d001718, 
    0x20cc1262, 0x61d02223, 0x84001262, 0x61550aa0, 0x0a0051c4, 0x00001804, 0x84001262, 0x61850aa0, 
    0x0a0051c4, 0x00002304, 0x80001140, 0x24050aa0, 0x0a006104, 0x02006184, 0xfaf0115b, 0x21246125, 
    0x20cc1162, 0x61b02526, 0x84001162, 0x61450aa0, 0x0a0051c4, 0x00002604, 0x80000020, 0x00004000, 
    0x00000000, 0x000000a0, 0x80000061, 0x61954220, 0x00000000, 0x3dc00000, 0x80000061, 0x61554220, 
    0x00000000, 0x3e000000, 0x80000061, 0x61154220, 0x00000000, 0x3e600000, 0x80000061, 0x51d54220, 
    0x00000000, 0x3ed00000, 0x80001e61, 0x51b54aa0, 0x00000000, 0x3f333333, 0x80000061, 0x61854aa0, 
    0x00000000, 0x3f666666, 0x80000061, 0x61454aa0, 0x00000000, 0x3f733333, 0x80000061, 0x61054aa0, 
    0x00000000, 0x3f7d70a4, 0x80000061, 0x51c54aa0, 0x00000000, 0x3f800000, 0x00140070, 0x00018aa0, 
    0x5a105504, 0x00000000, 0x64848461, 0x00020054, 0x0414002e, 0x0000c000, 0x00000590, 0x00000590, 
    0x00141970, 0x00018aa0, 0x5a105504, 0x3d00346e, 0x0414002e, 0x0000c000, 0x00000538, 0x00000538, 
    0x00141970, 0x00010aa0, 0x5a105504, 0x00006194, 0x0414002e, 0x0000c000, 0x000003f0, 0x000003f0, 
    0x00141970, 0x00010aa0, 0x5a105504, 0x00006154, 0x0414002e, 0x0000c000, 0x000002b0, 0x000002b0, 
    0x00141970, 0x00010aa0, 0x5a105504, 0x00006114, 0x0414002e, 0x0000c000, 0x00000168, 0x00000168, 
    0x00141970, 0x00010aa0, 0x5a105504, 0x000051d4, 0x1414002e, 0x0000c000, 0x00000120, 0x00000120, 
    0x80000040, 0x01150aa0, 0x0a0051d4, 0x02006114, 0x80000061, 0x03054220, 0x00000000, 0x4f800000, 
    0x80001165, 0x02058660, 0x16000114, 0x7f800000, 0x80000040, 0x01050aa0, 0x0a0051c4, 0x02006104, 
    0x00140040, 0x20010aa0, 0x0a105504, 0x02006114, 0x84001a62, 0x04058aa0, 0x0a000304, 0x3f800000, 
    0x80000970, 0x00018220, 0x42000204, 0x64000000, 0x94000062, 0x05458aa0, 0x0a000404, 0x2f800000, 
    0x80001165, 0x00018660, 0x16000114, 0x007fffff, 0x20840041, 0x05810106, 0x80001138, 0x07050aa0, 
    0x10000604, 0x00000000, 0x94000070, 0x00018660, 0x15000204, 0x00000000, 0x20842941, 0x01100708, 
    0x20841141, 0x05800809, 0x80000064, 0x30010110, 0x00003000, 0x00000000, 0x84001970, 0x00010aa0, 
    0x1a000104, 0x00000114, 0x94001262, 0x0a058aa0, 0x0a000904, 0x3f800000, 0x215c115b, 0x200a6157, 
    0x0014002e, 0x0000c000, 0x000003f8, 0x00000010, 0x0014002f, 0x00004000, 0x00000000, 0x00000028, 
    0x28a00061, 0x00185157, 0x0014002e, 0x0000c000, 0x000003d0, 0x00000010, 0x0014002f, 0x00004000, 
    0x00000000, 0x00000128, 0x80000040, 0x02050aa0, 0x0a006114, 0x02006154, 0x80000061, 0x04054220, 
    0x00000000, 0x4f800000, 0x80001165, 0x03058660, 0x16000204, 0x7f800000, 0x80000040, 0x01050aa0, 
    0x0a006104, 0x02006144, 0x00140040, 0x20010aa0, 0x0a105504, 0x02006154, 0x84001a62, 0x05458aa0, 
    0x0a000404, 0x3f800000, 0x80000970, 0x00018220, 0x42000304, 0x64000000, 0x94000062, 0x06058aa0, 
    0x0a000544, 0x2f800000, 0x80001165, 0x00018660, 0x16000204, 0x007fffff, 0x20840041, 0x06100207, 
    0x80001138, 0x08050aa0, 0x10000704, 0x00000000, 0x94000070, 0x00018660, 0x15000304, 0x00000000, 
    0x20842941, 0x01100809, 0x20841141, 0x0610090a, 0x80000064, 0x30010110, 0x00003000, 0x00000000, 
    0x84001970, 0x00010aa0, 0x1a000104, 0x00000204, 0x94001262, 0x0c058aa0, 0x0a000a04, 0x3f800000, 
    0x0014115b, 0x570402a0, 0x020a6144, 0x0c042000, 0x0014002e, 0x0000c000, 0x000002a8, 0x00000010, 
    0x0014002f, 0x00004000, 0x00000000, 0x00000120, 0x80000040, 0x01150aa0, 0x0a006154, 0x02006194, 
    0x80000061, 0x03054220, 0x00000000, 0x4f800000, 0x80001165, 0x02058660, 0x16000114, 0x7f800000, 
    0x80000040, 0x01050aa0, 0x0a006144, 0x02006184, 0x00140040, 0x20010aa0, 0x0a105504, 0x02006194, 
    0x84001a62, 0x04058aa0, 0x0a000304, 0x3f800000, 0x80000970, 0x00018220, 0x42000204, 0x64000000, 
    0x94000062, 0x05458aa0, 0x0a000404, 0x2f800000, 0x80001165, 0x00018660, 0x16000114, 0x007fffff, 
    0x20840041, 0x05810106, 0x80001138, 0x07050aa0, 0x10000604, 0x00000000, 0x94000070, 0x00018660, 
    0x15000204, 0x00000000, 0x20842941, 0x01100708, 0x20841141, 0x05800809, 0x80000064, 0x30010110, 
    0x00003000, 0x00000000, 0x84001970, 0x00010aa0, 0x1a000104, 0x00000114, 0x94001262, 0x0a058aa0, 
    0x0a000904, 0x3f800000, 0xf95c115b, 0x200a6157, 0x0014002e, 0x0000c000, 0x00000188, 0x00000010, 
    0x0014002f, 0x00004000, 0x00000000, 0x00000128, 0x80000040, 0x02058aa0, 0x0a006194, 0xbd00346e, 
    0x80000061, 0x04054220, 0x00000000, 0x4f800000, 0x80001165, 0x03058660, 0x16000204, 0x7f800000, 
    0x80000040, 0x01050aa0, 0x0a006184, 0x020051b4, 0x00140040, 0x20018aa0, 0x0a105504, 0xbd00346e, 
    0x84001a62, 0x05458aa0, 0x0a000404, 0x3f800000, 0x80000970, 0x00018220, 0x42000304, 0x64000000, 
    0x94000062, 0x06058aa0, 0x0a000544, 0x2f800000, 0x80001165, 0x00018660, 0x16000204, 0x007fffff, 
    0x20840041, 0x06100207, 0x80001138, 0x08050aa0, 0x10000704, 0x00000000, 0x94000070, 0x00018660, 
    0x15000304, 0x00000000, 0x20842941, 0x01100809, 0x20841141, 0x0610090a, 0x80000064, 0x30010110, 
    0x00003000, 0x00000000, 0x84001970, 0x00010aa0, 0x1a000104, 0x00000204, 0x94001262, 0x0c058aa0, 
    0x0a000a04, 0x3f800000, 0x0014115b, 0x570402a0, 0x020a51b4, 0x0c042000, 0x0014002e, 0x0000c000, 
    0x00000060, 0x00000010, 0x0014002f, 0x00004000, 0x00000000, 0x00000038, 0x80000041, 0x02058aa0, 
    0x0a0051b4, 0x41ff974f, 0xbc9c115b, 0x55025457, 0x0014002e, 0x0000c000, 0x00000028, 0x00000010, 
    0x0014002f, 0x00004000, 0x00000000, 0x00000018, 0xb09c005b, 0x55545457, 0x0014002f, 0x00004000, 
    0x00000000, 0x00000920, 0x80000061, 0x01050770, 0x00000524, 0x00000000, 0x00541265, 0x02058660, 
    0x16105504, 0x7f800000, 0x80034631, 0x060c0400, 0xfb00010c, 0x002c0000, 0x8000c731, 0x080c0500, 
    0xfb00010c, 0x00240000, 0x8000c831, 0x0a0c0600, 0xfb00010c, 0x002c0000, 0x8000c931, 0x0c0c0700, 
    0xfb00010c, 0x00200000, 0x80000061, 0x04054220, 0x00000000, 0x4f800000, 0x00d41a70, 0x00018220, 
    0x42100204, 0x64000000, 0x04541a62, 0x20018aa0, 0x0a000404, 0x3f800000, 0x00941165, 0x00018660, 
    0x16105504, 0x007fffff, 0x00540070, 0x00018660, 0x15100204, 0x00000000, 0x14d40062, 0x20018aa0, 
    0x0a102000, 0x2f800000, 0x80000061, 0x0d054110, 0x00000000, 0x00010001, 0x60200041, 0x20005510, 
    0x04941962, 0x0e058110, 0x01000d04, 0x00000000, 0x04540062, 0x0f058110, 0x01000d04, 0x00000000, 
    0x00141138, 0x12050aa0, 0x10101004, 0x00000000, 0x00541966, 0x00020110, 0x21100f04, 0x00100e04, 
    0x80000064, 0x31010220, 0x00003100, 0x00000000, 0x20202941, 0x57001214, 0x04541970, 0x00010aa0, 
    0x1a105704, 0x00105504, 0x00140070, 0x00018aa0, 0x1a105504, 0x00000000, 0x70201341, 0x20001420, 
    0x14540062, 0x20018aa0, 0x0a102000, 0x3f800000, 0x14140062, 0x20018aa0, 0x0a102000, 0x00000000, 
    0x70a00041, 0x20075122, 0x60a00041, 0x200f5116, 0x60200041, 0x20005218, 0x00140062, 0x22018aa0, 
    0x5a102200, 0x3f800000, 0x00141362, 0x20018aa0, 0x5a101604, 0x3f800000, 0x34208641, 0x0640221d, 
    0x34208741, 0x0840221f, 0x6c208841, 0x0a502222, 0x219c135b, 0x20061d21, 0x219c135b, 0x20081f23, 
    0x00140062, 0x1b058aa0, 0x5a101804, 0x3f800000, 0x26a0005b, 0x200a2220, 0x80940070, 0x00018660, 
    0x15005404, 0x00010001, 0x0014125b, 0x590402ac, 0x020a2104, 0x06241b04, 0x0014005b, 0x5b0402ac, 
    0x020a2304, 0x0a041b04, 0x0014895b, 0x5d0402ac, 0x020a2000, 0x0c041b04, 0x84800020, 0x00004000, 
    0x00000000, 0x00000178, 0x00141338, 0x01051aa0, 0x20105904, 0x00000000, 0x00141238, 0x06051aa0, 
    0x20105b04, 0x00000000, 0x00142a41, 0x01058aa0, 0x0a100104, 0x3ed555c5, 0x00141238, 0x0b051aa0, 
    0x20105d04, 0x00000000, 0x00142a41, 0x06058aa0, 0x0a100604, 0x3ed555c5, 0x00141238, 0x03050aa0, 
    0x30100104, 0x00000000, 0x80000061, 0x16054aa0, 0x00000000, 0x3f870a3d, 0x00141238, 0x09050aa0, 
    0x30100604, 0x00000000, 0x80000061, 0x17054aa0, 0x00000000, 0xbd6147ae, 0x00142b41, 0x0b058aa0, 
    0x0a100b04, 0x3ed555c5, 0x00141970, 0x00018aa0, 0x5a105904, 0x3b4d20b0, 0x00140041, 0x0f058aa0, 
    0x0a105904, 0x414eb852, 0x20a00a5b, 0x03161722, 0x00141438, 0x0d050aa0, 0x30100b04, 0x00000000, 
    0x20a02a5b, 0x09161720, 0x04141362, 0x5f050aa0, 0x0a100f04, 0x00102200, 0x00140070, 0x00018aa0, 
    0x5a105b04, 0x3b4d20b0, 0x00140041, 0x11058aa0, 0x0a105b04, 0x414eb852, 0x04141162, 0x66050aa0, 
    0x0a101104, 0x00102000, 0x00140070, 0x00018aa0, 0x5a105d04, 0x3b4d20b0, 0x00140041, 0x13058aa0, 
    0x0a105d04, 0x414eb852, 0x209c295b, 0x0d161718, 0x04141162, 0x68050aa0, 0x0a101304, 0x00101804, 
    0x80000020, 0x00004000, 0x00000000, 0x00000458, 0x00140038, 0x01051aa0, 0x20105904, 0x00000000, 
    0x00142941, 0x01058aa0, 0x0a100104, 0x3e232000, 0x00141138, 0x06050aa0, 0x30100104, 0x00000000, 
    0x80000061, 0x11054aa0, 0x00000000, 0x41958000, 0x78840061, 0x3f800012, 0x78840061, 0x4f800022, 
    0x209c095b, 0x06111213, 0x00141165, 0x20058660, 0x16101304, 0x7f800000, 0x04140062, 0x22018aa0, 
    0x0a002204, 0x3f800000, 0x00140970, 0x00018220, 0x42102004, 0x64000000, 0x14140062, 0x22018aa0, 
    0x0a102200, 0x2f800000, 0x00140038, 0x08051aa0, 0x20105b04, 0x00000000, 0x00541165, 0x00018660, 
    0x16101304, 0x007fffff, 0x00140070, 0x00018660, 0x15102004, 0x00000000, 0x80000061, 0x29054990, 
    0x00000000, 0x00010001, 0x60200041, 0x22001323, 0x04141262, 0x2a058110, 0x01002904, 0x00000000, 
    0x04540062, 0x2b058110, 0x01002904, 0x00000000, 0x00141138, 0x25050aa0, 0x10102304, 0x00000000, 
    0x00141966, 0x00020110, 0x21102a04, 0x00102b04, 0x00142a41, 0x08058aa0, 0x0a100804, 0x3e232000, 
    0x80000061, 0x19054aa0, 0x00000000, 0x3f560000, 0x80000064, 0x30010220, 0x00003000, 0x00000000, 
    0x00141238, 0x0a050aa0, 0x30100804, 0x00000000, 0x289c115b, 0x0651191a, 0x20200941, 0x1a002527, 
    0x04141970, 0x00010aa0, 0x1a101a04, 0x00101304, 0x70201241, 0x22002720, 0x209c295b, 0x0a111215, 
    0x14140062, 0x2c058aa0, 0x0a102000, 0x3f800000, 0x00141165, 0x2e058660, 0x16101504, 0x7f800000, 
    0x04140062, 0x20018aa0, 0x0a002204, 0x3f800000, 0x00140970, 0x00018220, 0x42102e04, 0x64000000, 
    0x14140062, 0x20018aa0, 0x0a102000, 0x2f800000, 0x00140038, 0x0c051aa0, 0x20105d04, 0x00000000, 
    0x00541165, 0x00018660, 0x16101504, 0x007fffff, 0x00140070, 0x00018660, 0x15102e04, 0x00000000, 
    0x60200041, 0x20001530, 0x04540062, 0x37058110, 0x01002904, 0x00000000, 0x04140062, 0x36058110, 
    0x01002904, 0x00000000, 0x00141138, 0x32050aa0, 0x10103004, 0x00000000, 0x00141966, 0x00020110, 
    0x21103604, 0x00103704, 0x00142a41, 0x0c058aa0, 0x0a100c04, 0x3e232000, 0x80000064, 0x30010220, 
    0x00003000, 0x00000000, 0x00141138, 0x0e050aa0, 0x30100c04, 0x00000000, 0x289c005b, 0x0a51191c, 
    0x20200941, 0x1c003234, 0x04141970, 0x00010aa0, 0x1a101c04, 0x00101504, 0x70201241, 0x20003420, 
    0x209c295b, 0x0e111217, 0x14140062, 0x38058aa0, 0x0a102000, 0x3f800000, 0x00141165, 0x3a058660, 
    0x16101704, 0x7f800000, 0x04140062, 0x20018aa0, 0x0a002204, 0x3f800000, 0x00140970, 0x00018220, 
    0x42103a04, 0x64000000, 0x14140062, 0x20018aa0, 0x0a102000, 0x2f800000, 0x00541165, 0x00018660, 
    0x16101704, 0x007fffff, 0x00140070, 0x00018660, 0x15103a04, 0x00000000, 0x60200041, 0x2000173c, 
    0x04540062, 0x43058110, 0x01002904, 0x00000000, 0x04140062, 0x42058110, 0x01002904, 0x00000000, 
    0x00141138, 0x3e050aa0, 0x10103c04, 0x00000000, 0x00141966, 0x00020110, 0x21104204, 0x00104304, 
    0x80000064, 0x30010220, 0x00003000, 0x00000000, 0x289c005b, 0x0e51191e, 0x20200941, 0x1e003e40, 
    0x04141970, 0x00010aa0, 0x1a101e04, 0x00101704, 0x70201241, 0x20004020, 0x14140062, 0x44058aa0, 
    0x0a102000, 0x3f800000, 0x00140038, 0x46051aa0, 0x20102c04, 0x00000000, 0x00140038, 0x48051aa0, 
    0x20103804, 0x00000000, 0x00142a41, 0x46058aa0, 0x0a104604, 0x429db000, 0x00141238, 0x4a051aa0, 
    0x20104404, 0x00000000, 0x00142a41, 0x48058aa0, 0x0a104804, 0x429db000, 0x00142941, 0x4a058aa0, 
    0x0a104a04, 0x429db000, 0x00141338, 0x5f050aa0, 0x30104604, 0x00000000, 0x00141238, 0x66050aa0, 
    0x30104804, 0x00000000, 0x00141138, 0x68050aa0, 0x30104a04, 0x00000000, 0x80000061, 0x02054aa0, 
    0x00000000, 0x477fff00, 0x78840061, 0x3f000003, 0xb4000061, 0x00104f22, 0x209c095b, 0x66020308, 
    0x00141161, 0x0e050a60, 0x00100804, 0x00000000, 0x209c005b, 0x5f020306, 0x00141962, 0x16058660, 
    0x45100e04, 0x00000000, 0x209c295b, 0x6802030a, 0x00141261, 0x0c050a60, 0x00100604, 0x00000000, 
    0x00141a62, 0x18058220, 0x51101604, 0xffffffff, 0xb4080061, 0x00105026, 0x00141161, 0x10050a60, 
    0x00100a04, 0x00000000, 0x00141c62, 0x12058660, 0x45100c04, 0x00000000, 0x68201c69, 0x01001820, 
    0x00100069, 0x24058670, 0x05202204, 0x00030003, 0x02101d69, 0x28058670, 0x05202604, 0x00030003, 
    0x00141d62, 0x1a058660, 0x45101004, 0x00000000, 0x00141d62, 0x14058220, 0x51101204, 0xffffffff, 
    0x38001c40, 0x0510242a, 0x38081c40, 0x0510282c, 0x00141c62, 0x1e058220, 0x51101a04, 0xffffffff, 
    0xac201c66, 0x1400201c, 0x00172a31, 0x00000000, 0xfb082a24, 0x00041c24, 0x0014002f, 0x00004000, 
    0x00000000, 0x00000010, 0x28100061, 0x00104c7f, 0x80022031, 0x00000004, 0x30207f0c, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};
#endif // !defined(MEDIA_BIN_SUPPORT) || defined(MEDIA_BIN_DLL)