Grat-OS
======

## Grat-OS, some ISOs are available here

`https://repo.grat-os.fr/isos/`

or Backup repo here:

`http://gratos.mesfichiers.eu/?dir=Isos`

## Grat-OS, please following these commands to install the base

## on a normal Grat-OS in root

```bash
cards install cards.devel git
wget https://code.grat-os.fr/Grat-OS/base/raw/branch/dev/scripts/install-grat-os.in -O install-grat-os
```

## You can continue
```bash
chmod -v 755 install-grat-os
mv -v install-grat-os /usr/bin/install-grat-os
```

## If you've already make the installation process, you have to remove the LFS user from the Grat-OS base by
```bash
userdel lfs
rm -r /home/lfs
rm -r /mnt/lfs
groupdel lfs
```

## After that or if you didn't make an installation process, you have to run these following commands
```bash
export LFS=/mnt/lfs
mkdir -pv $LFS
```

## Please note that you have to choose your partition in the next command, here /dev/sdb2
```bash
mount /dev/sdb2 $LFS
```

## It's time to begin pass1
## make sure the LFS variable is set by
```
echo $LFS
```

## If nothing is in the output, make
```bash
export LFS=/mnt/lfs
```

## Now, create the directories
```bash
mkdir -vp $LFS/{sources,tools}
ln -svf $LFS/tools /
ln -svf $LFS/sources /
```

## Create the LFS user
```bash
groupadd lfs
useradd -s /bin/bash -g lfs -m -k /dev/null lfs
passwd lfs
chown -v lfs $LFS/{tools,sources}
chmod -v a+wt $LFS/sources
chown -v lfs $LFS
```

## Now go in the LFS user

```bash
su - lfs
```

## Set the LFS variable in LFS User

```bash
export LFS=/mnt/lfs
```

## Set the correct profile for LFS User
```bash
cat > /home/lfs/.bash_profile << "EOF"
exec env -i HOME=$HOME TERM=$TERM PS1='\u:\w\$ ' /bin/bash
EOF

echo "set +h
umask 022
LFS=$LFS
LC_ALL=POSIX
LFS_TARGET=$(uname -m)-lfs-linux-gnu
PATH=/home/lfs/bin:/tools/bin:/bin:/usr/bin
export LFS LC_ALL LFS_TARGET PATH" > /home/lfs/.bashrc

source ~/.bashrc
```

## You are in the LFS user, now continue the installation with
```bash
git clone https://code.grat-os.fr/Grat-OS/base dev
```

Be careful, the default branch is `dev`, you might want to use stable branch instead to have the latest stable base as below.

```bash
git clone -b stable https://code.grat-os.fr/Grat-OS/base dev
```

Then:

```bash
cd dev
scripts/runmebeforepass1
```

## Normally, all will be good with the message above

```
====> Successfull configured
```

## Do the first pass

```bash
cd chroot
pass
```

## All will be ok with the message after a long time, which depends of your machine

```
=======> Building '/home/lfs/dev/chroot/cards/Pkgfile' succeeded.
/home/lfs/dev/chroot
```

## Go to pass2 :

## The rest of installation will be done in root

```bash
exit
```

## check the LFS variable, as it should return `/mnt/lfs`

```bash
echo $LFS
```

## if the result is correct continue with
```bash
chown -R root:root $LFS
install -dv -m0750  $LFS/root
ln -sv dev/scripts $LFS/root/bin
mv /home/lfs/dev $LFS/root/
cd $LFS/root/dev/base/grat-os
```

## make the first package
```bash
/tools/bin/pkgmk -cf ../../../bin/pkgmk.conf.passes
```

## install it
```bash
/tools/bin/pkgadd -r $LFS grat-os1*
/tools/bin/pkgadd -r $LFS grat-os.man1*
```

## check if it's present, it should be shown as:

```bash
/tools/bin/pkginfo -r $LFS -i

(base) grat-os 1.0-RC1-1...
(base) grat-os.man 1.0-RC1-1...
```

## make the configuration
```bash
VERSION="dev" install-grat-os -ic
```

## We mount the folders

### Two ways, way1

```bash
mount -v --bind /dev $LFS/dev
mount -vt devpts devpts $LFS/dev/pts -o gid=5,mode=620` \
mount -vt proc proc $LFS/proc` \
mount -vt sysfs sysfs $LFS/sys` \
mount -vt tmpfs tmpfs $LFS/run

if [ -h /dev/shm ]; then mkdir -pv $LFS/$(readlink $LFS/dev/shm);fi` \
chmod 1777 /dev/shm` \
cp -v /etc/resolv.conf $LFS/etc
```

## We check the correct mount

```bash
mount|grep $LFS
```

## will normally return if it's on /dev/sda2

```
/dev/sda2 on /mnt/lfs type ext4 (rw) \
/devtmpfs on /mnt/lfs/dev type devtmpfs (rw,nosuid,relatime,size=16300988k,nr_inodes=4075247,mode=755) \
devpts on /mnt/lfs/dev/pts type devpts (rw,relatime,gid=5,mode=620,ptmxmode=000) \
proc on /mnt/lfs/proc type proc (rw,relatime) \
sysfs on /mnt/lfs/sys type sysfs (rw,relatime) \
tmpfs on /mnt/lfs/run type tmpfs (rw,relatime)
```

## continue in chroot
```bash
chroot "$LFS" /usr/bin/env -i HOME=/root TERM="$TERM" PS1='\u:\w\$ ' \
/bin/bash --login +h
```

### Way 2

```bash
install-grat-os -ec
```

## Some "command not found" will appears, but not important here

## continue with
```bash
export PATH=/bin:/usr/bin:/sbin:/usr/sbin:/tools/bin:/root/bin

cd /root/dev/base

pass
```

## After a moment the scripts says you have to install bash manually, go with the commands

```bash
exit
cd $LFS/root/dev/base/bash
for PACK in *.xz; do /tools/bin/pkgadd -r $LFS $PACK;done
/tools/bin/pkginfo -r $LFS -i|grep bash
```

## The last command will return that if succeeds
```
(base) bash 4.4-1 \
(base) bash.da 4.4-1 \
(base) bash.de 4.4-1 \
(base) bash.devel 4.4-1 \
(base) bash.doc 4.4-1 \
...
```

## return in chroot

```bash
chroot "$LFS" /usr/bin/env -i HOME=/root TERM="$TERM" PS1='\u:\w\$ ' \
/bin/bash --login +h
export PATH=/bin:/usr/bin:/sbin:/usr/sbin:/tools/bin:/root/bin
cd /root/dev/base
pass
```

## The last pass will return at end

```
ADD: ca-certificates-20150725, 1282 files: 100% \
=======> Installing 'ca-certificates1418739487x86_64.cards.tar' succeeded. \
=======> compress ca-certificates1418739487x86_64.cards.tar
```

## After that use the "mybld" script to continue automated compilation, need to complete that
## Commit it later, no need to continue next commands

## Now, follow few commands to configure your grat-os-systemd

```bash
exit
echo $LFS
```

## The ouptput have to be "/mnt/lfs "

## Go back in chroot

```bash
chroot $LFS /usr/bin/env -i HOME=/root TERM="$TERM" PS1='\u: \w\$' /bin/bash --login
```

## To boot, you have to compile the kernel with 
```bash
cd /usr/ports/base/base/kernel-lts
pkgmk -d -i
```

## make a grub, if you don't have a working linux on an other partition or harddrive, with

```bash
cards depcreate grub
grub-install /dev/sda
cat > /boot/grub/grub.cfg << "EOF"
#Begin /boot/grub/grub.cfg
set default=0
set timeout=5
insmod ext2
set root=(hd0,2)
menuentry "Grat-OS" {
        linux   /boot/kernel root=/dev/sda2 ro
}
EOF
```

## make a /etc/hostname

```bash
echo "grat-os-systemd" > /etc/hostname
```

## make a /etc/hosts like that if you have a network with DHCP

```bash
cat > /etc/hosts << "EOF"
#Begin /etc/hosts

127.0.0.1 localhost
127.0.1.1 grat-os-systemd.home grat-os-systemd
::1       localhost ip6-localhost ip6-loopback
ff02::1   ip6-allnodes
ff02::2   ip6-allrouters

#End /etc/hosts
EOF
```

## make a working network with dhcpcd
```bash
cards depcreate dhcpcd
```

## after compiling dhcpcd, you have to enable a systemd service. you have to know your network interface with
```bash
ip a
systemctl enable dhcpcd@"your network interface"
```

## make a text editor
```bash
cards depcreate vim
```

## make a link for /etc/resolv.conf

```bash
ln -sfv /run/systemd/resolve/resolv.conf /etc/resolv.conf
```

## make a fstab like that if you have your partition in /dev/sda2

```bash
cat > /etc/fstab << "EOF"
#Begin /etc/fstab

#file system  mount-point  type     options             dump  fsck order 
/dev/sda2     /            ext4    defaults            1     1
#/dev/<yyy>     swap         swap     pri=1               0     0

#End /etc/fstab
EOF 
```

## make a file for time

```bash
cat > /etc/adjtime << "EOF"
0.0 0 0.0
0
LOCAL
EOF
```

## make a /etc/vconsole.conf like that il you're french

```bash
cat > /etc/vconsole.conf << "EOF"
KEYMAP=fr-latin9
FONT=Lat2-Terminus16
EOF
```

## make a /etc/locale.conf for example in french

```bash
cat > /etc/locale.conf << "EOF"
LANG=fr_FR.utf8
EOF
```

## make a /etc/os-release

```bash
cat > /etc/os-release << "EOF"
NAME="Grat-OS"
VERSION="grat-os"
ID=lfs
PRETTY_NAME="grat-os"
VERSION_CODENAME="<your name here>"
EOF
```

## Have a password on root

```bash
passwd
```

## make a new unprivileged user

```bash
nu
```

## Umount all the filesystems
To known what to umount \

```bash
mount | grep $LFS \
```

and unmount the filesystems

```bash
umount /mnt/lfs/{run,proc,sys,dev/pts,dev,}
```

## After that you will normally have to reboot on your new Grat-OS and enjoy to start a build-collection
